-- 
--  Quest Central - Reports
--  Repository creation script for DB2 on Linux, Windows and UNIX  
--

#DELIMITER ";";

#SYNC 10;

CREATE TABLE QUEST.QCREPORT_REPO045
 (RPT_NAME       CHARACTER(30)   NOT NULL,
  RPT_CREATOR    VARCHAR(128)    NOT NULL DEFAULT USER,
  RPT_TIMESTAMP  TIMESTAMP       NOT NULL,
  FILENAME       VARCHAR(200),
  FILE_TYPE      VARCHAR(100)
 )
  DATA CAPTURE NONE
  IN QUESTSPACE;

#SYNC 20;

ALTER TABLE QUEST.QCREPORT_REPO045
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 30;

COMMENT ON TABLE QUEST.QCREPORT_REPO045
  IS 'QC REPORT REPO V01.0';

#SYNC 40;

GRANT CONTROL ON TABLE QUEST.QCREPORT_REPO045 TO PUBLIC;

#SYNC 50;

CREATE UNIQUE INDEX QUEST.QCREPORT_REPO_IX
  ON QUEST.QCREPORT_REPO045
 (RPT_NAME        ASC,
  RPT_CREATOR     ASC,
  RPT_TIMESTAMP   ASC
 )
  PCTFREE 10
  DISALLOW REVERSE SCANS;

#SYNC 60;

CREATE TABLE QUEST.QCREPORT_DETAIL045
 (RPT_NAME       CHARACTER(30)    NOT NULL,
  RPT_CREATOR    VARCHAR(128)     NOT NULL DEFAULT USER,
  RPT_TIMESTAMP  TIMESTAMP        NOT NULL,
  FILENAME       VARCHAR(200),
  SEQUENCE       INTEGER,
  RPT_DATA       CLOB(65536)                NOT LOGGED  COMPACT
 )
  DATA CAPTURE NONE
  IN QUESTSPACE;

#SYNC 70;

ALTER TABLE QUEST.QCREPORT_DETAIL045
  LOCKSIZE ROW
  APPEND OFF
  NOT VOLATILE;

#SYNC 80;

COMMENT ON TABLE QUEST.QCREPORT_DETAIL045
  IS 'QC REPORT REPO V01.0';

#SYNC 90;

GRANT CONTROL ON TABLE QUEST.QCREPORT_DETAIL045 TO PUBLIC;

#SYNC 100;

CREATE UNIQUE INDEX QUEST.QCREPORT_DET_IX
  ON QUEST.QCREPORT_DETAIL045
 (RPT_NAME        ASC,
  RPT_CREATOR     ASC,
  RPT_TIMESTAMP   ASC,
  FILENAME        ASC,
  SEQUENCE        ASC
 )
  PCTFREE 10
  DISALLOW REVERSE SCANS;

#SYNC 110;

#DELIMITER RESTORE;

#SYNC 120;